#include "IPhysicalWheelJoint.h"

namespace PhysicsEngine
{

IPhysicalWheelJoint::IPhysicalWheelJoint()
{
}

IPhysicalWheelJoint::IPhysicalWheelJoint(int objectid, IPhysicalBody *body1, IPhysicalBody *body2, Vector3f axis1, Vector3f axis2, float hardness, float bounciness,float maxtorque):IPhysicalJoint(objectid, body1,body2)
{
	this->axis1 = axis1;
	this->axis2 = axis2;
	this->hardness = hardness;
	this->bounciness = bounciness;
	this->maxtorque = maxtorque;
}

IPhysicalWheelJoint::~IPhysicalWheelJoint()
{
}

Vector3f IPhysicalWheelJoint::GetAxis1()
{
	return axis1;
}

Vector3f IPhysicalWheelJoint::GetAxis2()
{
	return axis2;
}

float IPhysicalWheelJoint::GetHardness()
{
	return hardness;
}

float IPhysicalWheelJoint::GetBounciness()
{
	return bounciness;
}


float IPhysicalWheelJoint::GetMaxTorque()
{
	return maxtorque;
}

void IPhysicalWheelJoint::SetAxis1(Vector3f value)
{
	this->axis1 = value;
}

void IPhysicalWheelJoint::SetAxis2(Vector3f value)
{
	this->axis2 = value;
}

void IPhysicalWheelJoint::SetHardness(float value)
{
	this->hardness = value;
}

void IPhysicalWheelJoint::SetBounciness(float value)
{
	this->bounciness = value;
}

void IPhysicalWheelJoint::SetMaxTorque(float value)
{
	this->maxtorque = value;
}

DataJoint *IPhysicalWheelJoint::GetDataJoint()
{
	return this->GetDataWheelJoint();
}

}
